﻿using System.Collections.Generic;

namespace PpmsDataWebService.ModelsEnumTypes
{
    public enum VAFacilityType
    {
        VAMC = 1,
        PC_CBOC = 2,
        OOS = 3,
        MS_CBOC = 4,
        HCC = 5
    }

    public struct VAFacilityId
    {
        public VAFacilityId(int number, int value, string name) : this()
        {
            Number = number;
            Value = value;
            FacilityTypeName = name;
        }

        public int Number  { get;  }
        public int Value  { get; }
        public string FacilityTypeName { get; }
    }

    public class VAFacilityIds
    {
        private static List<VAFacilityId> _vaFacilityIds;
        static VAFacilityIds()
        {
            _vaFacilityIds = new List<VAFacilityId>();
            _vaFacilityIds.Add(new VAFacilityId(0, 0, "AnyFacilityType"));
            _vaFacilityIds.Add(new VAFacilityId(1, 767940000, "VAMC"));
            _vaFacilityIds.Add(new VAFacilityId(2, 767940001, "PC_CBOC"));
            _vaFacilityIds.Add(new VAFacilityId(3, 767940005, "OOS"));
            _vaFacilityIds.Add(new VAFacilityId(4, 767940002, "MS_CBOC"));
            _vaFacilityIds.Add(new VAFacilityId(5, 767940004, "HCC"));

        }
       
        public static VAFacilityId GetFacility(int number)
        {
            return _vaFacilityIds.Find(n => n.Number == number);
        }

        
    }
}